VERSION 5.00
Begin VB.Form frmSCP 
   Caption         =   "Commitment SCP"
   ClientHeight    =   4512
   ClientLeft      =   23412
   ClientTop       =   2820
   ClientWidth     =   6060
   LinkTopic       =   "Form1"
   ScaleHeight     =   4512
   ScaleWidth      =   6060
   StartUpPosition =   2  'CenterScreen
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   2000
      Left            =   5640
      Top             =   1440
   End
   Begin VB.CheckBox UseNewAssociation 
      Caption         =   "Send N-EVENT_REPORT on new association"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   1560
      Value           =   1  'Checked
      Width           =   3615
   End
   Begin VB.TextBox Text1 
      Height          =   2415
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   0
      Top             =   1920
      Width           =   5895
   End
   Begin VB.Label Label1 
      Caption         =   $"Commitment SCP.frx":0000
      Height          =   1455
      Left            =   120
      TabIndex        =   2
      Top             =   0
      Width           =   5295
   End
End
Attribute VB_Name = "frmSCP"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit
Dim requests As New DicomDataSets
Dim WithEvents server As DicomServer
Attribute server.VB_VarHelpID = -1

' This type holds information on remote AEs to communicate with
' In a real applicaton, it would of course be a database table

Private Type AE
    MyAET As String
    RemoteAET As String
    IP As String
    Port As Long
End Type

Dim AEList(10) As AE

Private Sub Form_Load()
    Set server = New DicomServer
    server.DefaultStatus = &HC000
    server.Listen 104
    
    AEList(1).MyAET = "SC_SCP"
    AEList(1).RemoteAET = "SC_SCU"
    AEList(1).IP = "localhost"
    AEList(1).Port = 10400
End Sub

Private Sub Timer1_Timer()
' Handle a single resonse
' for a real application this would be triggered by confirmation that the images were "safe"
' not by a timer
    
    Dim connection2 As DicomConnection
    Dim request As DicomDataSet
    Set request = requests(1)
    Dim Qlevel As String
    Dim Qroot As String
    Dim image_list() As String
    Dim li_nofImages As Integer
    Dim lo_dataset As New DicomDataSet
    Dim ll_event_type_ID As Long
    Dim AEIndex As Integer, i As Integer, Remote As AE
    Dim RemoteAET As String
    Dim OriginalConnection As DicomConnection
    
    Set request = requests(1)
    Set OriginalConnection = request.Tag
    Set request.Tag = Nothing
    
    'create dataset to send back
    
    Dim ds1 As New DicomDataSet
    ds1.Name = request.Name

    ds1.Attributes.Add &H8, &H1199, request.Attributes(&H8, &H1199)
    ds1.Attributes.Add &H8, &H1195, request.Attributes(&H8, &H1195)
    
    ds1.Attributes.Add 8, &H54, request.Attributes(&H99, &H1099).Value ' where images may be found
    
    ' handle differently according to whether we are using the original association
    
    If UseNewAssociation Then
    
        ' First, find the AE to call back to
        RemoteAET = request.Attributes(&H99, &H1098).ValueByIndex(1)
        
        For i = 1 To UBound(AEList, 1)
            If AEList(i).RemoteAET = RemoteAET Then
                AEIndex = i
            End If
        Next
        If AEIndex = 0 Then Log "AET not found": GoTo er2
        
        Remote = AEList(AEIndex)
        
        Set connection2 = New DicomConnection
        connection2.Contexts.Add doSOP_StorageCommitmentPush
        connection2.Contexts(1).RequestorSCURole = False
        connection2.Contexts(1).RequestorSCPRole = True
        connection2.SetDestination Remote.IP, Remote.Port, Remote.MyAET, Remote.RemoteAET '    "localhost", 10400, "CALLING_AE", "CALLED_AE"
        connection2.NEventReport doSOP_StorageCommitmentPush, doInstance_StorageCommitmentPush, 1, ds1
        connection2.Close
    Else
        On Error GoTo er1
        OriginalConnection.NEventReport doSOP_StorageCommitmentPush, doInstance_StorageCommitmentPush, 1, ds1
    End If

    Log "N-Event-Report sent"
    requests.Remove 1
    Timer1.Enabled = requests.Count > 0 ' only leave if there is another to do
    
    Exit Sub
er1:
    Log "Cannot use original association, as it is now closed"
er2:
    requests.Remove 1
    Timer1.Enabled = requests.Count > 0 ' only leave if there is another to do
End Sub

Private Sub server_NormalisedReceived(ByVal connection As DicomObjects8.DicomConnection)
    Dim request As DicomDataSet
    Dim ls_AffectedSOPInstanceUID As String
    Dim ls_CommandField As Long
    Dim LL_status As Long
    Dim ls_EventTypeID As String

    Set request = connection.request
    ls_CommandField = connection.Command.Attributes.Item(&H0, &H100).Value
    
    Log "Incoming operation received : " & connection.Operation
    Select Case ls_CommandField
    Case &H140 ' N-CREATE-REQ
    Case &H120 ' N-SET-REQ
    Case &H130 ' N-ACTION-REQ
        '
        ' proccessing
        ls_AffectedSOPInstanceUID = connection.Command.Attributes.Item(&H0, &H1001).Value
        ls_EventTypeID = connection.Command.Attributes.Item(&H0, &H1008).Value
        If ls_AffectedSOPInstanceUID <> doInstance_StorageCommitmentPush Then
            '
            ' if AffectedSOPInstanceUID does not correspond to the well-known UID
            ' of the Storage Commitment Push Model SOP Instance, report an error
            LL_status = &H112 ' No such Object Instance
        ElseIf ls_EventTypeID <> "1" Then
            '
            ' if Action Type ID not 1 or 2, report an error
            LL_status = &H123 ' No such Action Type
        Else
            '
            ' Send N-ACTION-RESP with success status
            connection.Tag = "N-ACTION"
            LL_status = &H0
            ' Send N-EVENT-REPORT  (using same or additional association) from ActiomComplete event
        End If
        
        Set request.Tag = connection ' so we know where to call back to !
        
        'use private element to store the AETs (in a real application, this would of course all be in a database)
        request.Attributes.AddExplicit &H99, &H1098, "AE", connection.CallingAET
        request.Attributes.AddExplicit &H99, &H1099, "AE", connection.CalledAET
        
        requests.Add request
    
    End Select
    
    connection.SendStatus LL_status
    
    Timer1.Enabled = True
End Sub

Sub Log(msg As String)
    Text1 = Text1 & msg & vbCrLf
End Sub

